import numpy as np
from random import randint, random, choice

taille = (6,6)
facteurTaille = 20
probaCarre = 0.1

matrice = np.zeros(taille, dtype=np.uint8)
# Codage des formes :
# 3 premiers bits (poids faibles) : forme
# 0 -> vide
# 1 -> ◴
# 2 -> ◵
# 3 -> ◶
# 4 -> ◷
# 5 -> ◻
# 4 bits suivants : contraintes sur les formes
# bit 3 -> pas ◴
# bit 4 -> pas ◵
# bit 5 -> pas ◶
# bit 6 -> pas ◷
# 7e bit non utilisé

# On commence par mettre les carrés
for i in range(taille[0]):
    for j in range(taille[1]):
        if random() < probaCarre:# Un carré
            matrice[i,j] = 5

# On enlève des carrés s'il y en a plus de 2 d’affilée sur la même colonne
série = 0
for i in range(taille[0]):
    for j in range(taille[1]):
        if matrice[i,j] != 5:# pas un carré
            série = 0
        elif série > 2:# le 3e carré de suite
            matrice[i,j] = 0
            série = 0
        else:# un carré
            série += 1

# On enlève des carrés s'il y en a plus de 2 d’affilée sur la même ligne
série = 0
for j in range(taille[1]):
    for i in range(taille[0]):
        if matrice[i,j] != 5:# pas un carré
            série = 0
        elif série > 2:# le 3e carré de suite
            matrice[i,j] = 0
            série = 0
        else:# un carré
            série += 1

# Pas moins de deux espace entre deux carrés
for i in range(taille[0]):
    for j in range(1,taille[1]-1):
        if matrice[i,j-1] == 5 and matrice[i,j] != 5:# pas un carré
            matrice[i,j+1] = 0
            
for j in range(taille[1]):
    for i in range(1,taille[0]-1):
        if matrice[i-1,j] == 5 and matrice[i,j] != 5:# pas un carré
            matrice[i+1,j] = 0

        
# Quarts de cercle bordant des carrés
for j in range(taille[1]):
    for i in range(taille[0]):
        if matrice[i,j] & 0b00000111 == 5:# un carré
            if i-1 >= 0:# à gauche d'un carré
                matrice[i-1,j] |= 0b01100000
            if i+1 < taille[0]:# à droite d'un carré
                matrice[i+1,j] |= 0b00011000
            if j-1 >= 0:# au dessus d'un carré
                matrice[i,j-1] |= 0b00110000
            if j+1 < taille[1]:# en dessous d'un carré
                matrice[i,j+1] |= 0b01001000

for i in range(taille[0]):
    for j in range(taille[1]):
        if matrice[i,j] & 0b00000111 == 0:
            L = []
            if matrice[i,j] & 0b00001000 == 0:
                L.append(1)
            if matrice[i,j] & 0b00010000 == 0:
                L.append(2)
            if matrice[i,j] & 0b00100000 == 0:
                L.append(3)
            if matrice[i,j] & 0b01000000 == 0:
                L.append(4)
            matrice[i,j] = choice(L)

svg = ''
svg += '<?xml version="1.0" encoding="utf-8"?>\n'
svg += f'<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="{taille[0]*facteurTaille}" height="{taille[1]*facteurTaille}" fill="#511741">\n'

for i in range(taille[0]):
    for j in range(taille[1]):
        if matrice[i,j] & 0b00000111 == 1:# ◴
            svg += f'<path d="M{facteurTaille*(i+1)} {facteurTaille*j} v{facteurTaille} h-{facteurTaille} a{facteurTaille} {facteurTaille} 0 0 1 {facteurTaille} -{facteurTaille}z" />'
        elif matrice[i,j] & 0b00000111 == 2:# ◵
            svg += f'<path d="M{facteurTaille*i} {facteurTaille*j} h{facteurTaille} v{facteurTaille} a{facteurTaille} {facteurTaille} 0 0 1 -{facteurTaille} -{facteurTaille}z" />'
        elif matrice[i,j] & 0b00000111 == 3:# ◶
            svg += f'<path d="M{facteurTaille*i} {facteurTaille*j} h{facteurTaille} a{facteurTaille} {facteurTaille} 0 0 1 -{facteurTaille} {facteurTaille}z" />'
        elif matrice[i,j] & 0b00000111 == 4:# ◷
            svg += f'<path d="M{facteurTaille*i} {facteurTaille*j} a{facteurTaille} {facteurTaille} 0 0 1 {facteurTaille} {facteurTaille} h-{facteurTaille} z" />'
        elif matrice[i,j] & 0b00000111 == 5:# ◻
            svg += f'<path d="M{facteurTaille*i} {facteurTaille*j} h{facteurTaille} v{facteurTaille} h-{facteurTaille}z" />'

svg += '</svg>'


with open("test.svg","w") as f:
    f.write(svg)